import { jsx, jsxs } from "react/jsx-runtime";
import { B as Badge } from "./badge-CnqJovSa.js";
import { B as Button } from "./button-CoRGprmX.js";
import { D as DropdownMenu, a as DropdownMenuTrigger, b as DropdownMenuContent, c as DropdownMenuItem } from "./dropdown-menu-DONmDWr6.js";
import { Link } from "@inertiajs/react";
import { format } from "date-fns";
import { CheckCircle, AlertCircle, Clock, MoreVertical, Eye, Pencil } from "lucide-react";
import AssignmentForm from "./assignment-form-BYLinggN.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "react";
import "@radix-ui/react-dropdown-menu";
import "./datetime-picker-vvicdyd7.js";
import "react-day-picker";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "./select-DLRJE4Jo.js";
import "@radix-ui/react-select";
import "./use-lang-44ndmTOc.js";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./checkbox-DmVJz5lb.js";
import "@radix-ui/react-checkbox";
import "./dialog-Bzzm0V8u.js";
import "@radix-ui/react-dialog";
import "./input-BPdrsFAc.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./inertia-BtwbgBI3.js";
import "richtor";
/* empty css                 */
const AssignmentTableColumn = (slug, translate, enrollmentsCount) => {
  const { table } = translate;
  return [
    {
      accessorKey: "title",
      header: "Assignment Details",
      cell: ({ row }) => {
        const assignment = row.original;
        return /* @__PURE__ */ jsxs("div", { className: "space-y-1 py-2", children: [
          /* @__PURE__ */ jsx("p", { className: "text-base font-semibold", children: assignment.title }),
          /* @__PURE__ */ jsxs("div", { className: "text-muted-foreground flex flex-wrap items-center gap-3 text-xs", children: [
            /* @__PURE__ */ jsxs("span", { className: "flex items-center gap-1", children: [
              /* @__PURE__ */ jsx(CheckCircle, { className: "h-3 w-3" }),
              "Total: ",
              assignment.total_mark
            ] }),
            /* @__PURE__ */ jsxs("span", { className: "flex items-center gap-1", children: [
              "Pass: ",
              assignment.pass_mark
            ] }),
            /* @__PURE__ */ jsxs("span", { className: "flex items-center gap-1", children: [
              "Retakes: ",
              assignment.retake
            ] })
          ] })
        ] });
      }
    },
    {
      accessorKey: "deadline",
      header: "Deadline",
      cell: ({ row }) => {
        const deadline = row.getValue("deadline");
        const isExpired = /* @__PURE__ */ new Date() > new Date(deadline);
        return /* @__PURE__ */ jsxs("div", { className: "py-2", children: [
          /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
            isExpired ? /* @__PURE__ */ jsx(AlertCircle, { className: "text-destructive h-4 w-4 flex-shrink-0" }) : /* @__PURE__ */ jsx(Clock, { className: "text-primary h-4 w-4 flex-shrink-0" }),
            /* @__PURE__ */ jsxs("div", { children: [
              /* @__PURE__ */ jsx("p", { className: `text-sm font-medium ${isExpired ? "text-destructive" : ""}`, children: format(new Date(deadline), "MMM dd, yyyy") }),
              /* @__PURE__ */ jsx("p", { className: "text-muted-foreground text-xs", children: format(new Date(deadline), "hh:mm a") })
            ] })
          ] }),
          isExpired && /* @__PURE__ */ jsx(Badge, { variant: "destructive", className: "mt-1 text-xs", children: "Expired" })
        ] });
      }
    },
    {
      accessorKey: "late_submission",
      header: () => /* @__PURE__ */ jsx("div", { className: "text-center", children: "Late Submission" }),
      cell: ({ row }) => {
        const assignment = row.original;
        const lateAllowed = assignment.late_submission;
        return /* @__PURE__ */ jsxs("div", { className: "py-2 text-center", children: [
          /* @__PURE__ */ jsx(Badge, { variant: lateAllowed ? "default" : "secondary", children: lateAllowed ? "Allowed" : "Not Allowed" }),
          lateAllowed && assignment.late_deadline && /* @__PURE__ */ jsxs("div", { className: "text-muted-foreground mt-1 text-xs", children: [
            "Until: ",
            format(new Date(assignment.late_deadline), "MMM dd")
          ] })
        ] });
      }
    },
    {
      accessorKey: "submissions",
      header: () => /* @__PURE__ */ jsx("div", { className: "text-center", children: "Submissions" }),
      cell: ({ row }) => {
        var _a, _b;
        const assignment = row.original;
        const totalSubmissions = ((_a = assignment.submissions) == null ? void 0 : _a.length) || 0;
        ((_b = assignment.submissions) == null ? void 0 : _b.filter((s) => s.status === "graded").length) || 0;
        return /* @__PURE__ */ jsxs("div", { className: "py-2 text-center", children: [
          /* @__PURE__ */ jsx("span", { className: "font-semibold", children: totalSubmissions }),
          " of ",
          /* @__PURE__ */ jsx("span", { className: "font-semibold", children: enrollmentsCount })
        ] });
      }
    },
    {
      id: "actions",
      header: () => /* @__PURE__ */ jsx("div", { className: "text-end", children: table.action }),
      cell: ({ row }) => {
        const assignment = row.original;
        return /* @__PURE__ */ jsx("div", { className: "flex justify-end py-2", children: /* @__PURE__ */ jsxs(DropdownMenu, { children: [
          /* @__PURE__ */ jsx(DropdownMenuTrigger, { asChild: true, children: /* @__PURE__ */ jsxs(Button, { variant: "secondary", size: "sm", className: "h-8 w-8 p-0", children: [
            /* @__PURE__ */ jsx("span", { className: "sr-only", children: "Open menu" }),
            /* @__PURE__ */ jsx(MoreVertical, { className: "h-4 w-4" })
          ] }) }),
          /* @__PURE__ */ jsxs(DropdownMenuContent, { align: "end", className: "space-y-1", children: [
            /* @__PURE__ */ jsx(DropdownMenuItem, { asChild: true, children: /* @__PURE__ */ jsxs(
              Link,
              {
                href: route("courses.edit", {
                  course: assignment.course_id,
                  tab: slug,
                  assignment: assignment.id
                }),
                className: "flex w-full cursor-pointer items-center gap-2",
                children: [
                  /* @__PURE__ */ jsx(Eye, { className: "h-4 w-4" }),
                  /* @__PURE__ */ jsx("span", { children: "View Submissions" })
                ]
              }
            ) }),
            /* @__PURE__ */ jsx(
              AssignmentForm,
              {
                title: "Update Assignment",
                assignment,
                handler: /* @__PURE__ */ jsxs(DropdownMenuItem, { onSelect: (e) => e.preventDefault(), className: "flex w-full cursor-pointer items-center gap-2", children: [
                  /* @__PURE__ */ jsx(Pencil, { className: "h-4 w-4" }),
                  /* @__PURE__ */ jsx("span", { children: "Update Assignment" })
                ] })
              }
            )
          ] })
        ] }) });
      }
    }
  ];
};
export {
  AssignmentTableColumn as default
};
